
#ifndef signal_t_h
#define signal_t_h

#include "nios.h"

class Signal
{
	public:	
//	static void Template(void);	
 
	static void ProcessSignalData(void); 								// BF new level 1 routine for signal processing
													// and math functions
    	static void Interpolate(int timebase, int start, unsigned char *SignalData, unsigned char *InterpolateResult);	//BF new interpolation routine
	static void LinearInterpolation(int x1, int y1, int x2, int y2, unsigned char *interpolation);	

	// Math calculation
	static void CalcMathMul(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData);
	static void CalcMathSub(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData);
	static void CalcMathAdd(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData);

	static void TestSignalGenerate(void);

	//----------------------------------------------------------------------------------------------------------------------------------------------------------
	static void USTB_Clear_Buffer(void);
	static void USTB_roll_signal(int Time_idx, unsigned char *DataArray_in, unsigned char *Signal);
	static void USTB_shift_signal(unsigned char *DataArray_in, unsigned char *Signal);
	//----------------------------------------------------------------------------------------------------------------------------------------------------------

	static void FFT_BuildTrigoTables(void);
	static void FFT_CalcSpectrum(unsigned char *Signal, int *Spectrum);
	static int iSqrt(int op);	//calculate square root
	//----------------------------------------------------------------------------------------------------------------------------------------------------------
	//static void LowPassFilter(unsigned char *RawData, int start, int stop, unsigned char *DisplayData);

	static void CalcMinMax(int start, int stop, int stepwidth ,unsigned char *SignalData1,  unsigned char *min, unsigned char *max);

};



#endif //signal_t_h
